<?php namespace Anomaly\ApiModule\Resource\Component\Formatter;

use Anomaly\ApiModule\Resource\ResourceBuilder;

/**
 * Class FormatterDefaults
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Formatter
 */
class FormatterDefaults
{

    /**
     * Default the form actions when none are defined.
     *
     * @param ResourceBuilder $builder
     */
    public function defaults(ResourceBuilder $builder)
    {
        if ($builder->getFormatters() === [] && $stream = $builder->getResourceStream()) {
            // Don't know.
        }
    }
}
