<?php namespace Anomaly\ApiModule\Resource\Component\Formatter\Command\Handler;

use Anomaly\ApiModule\Resource\Component\Formatter\Command\BuildFormatters;
use Anomaly\ApiModule\Resource\Component\Formatter\FormatterBuilder;

/**
 * Class BuildFormattersHandler
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Formatter\Listener\Command
 */
class BuildFormattersHandler
{

    /**
     * The formatter builder.
     *
     * @var \Anomaly\ApiModule\Resource\Component\Formatter\FormatterBuilder
     */
    protected $builder;

    /**
     * Create a new BuildFormattersHandler instance.
     *
     * @param FormatterBuilder $builder
     */
    public function __construct(FormatterBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Build formatters and load them to the resource.
     *
     * @param BuildFormatters $command
     */
    public function handle(BuildFormatters $command)
    {
        $this->builder->build($command->getBuilder());
    }
}
