<?php namespace Anomaly\ApiModule\Resource\Component\Formatter\Command;

use Anomaly\ApiModule\Resource\Component\Formatter\Contract\FormatterInterface;
use Anomaly\ApiModule\Resource\Resource;

/**
 * Class GetFormatterValue
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class GetFormatterValue
{

    /**
     * The resource object.
     *
     * @var \Anomaly\ApiModule\Resource\Resource
     */
    protected $resource;

    /**
     * The formatter object.
     *
     * @var \Anomaly\ApiModule\Resource\Component\Formatter\Contract\FormatterInterface
     */
    protected $formatter;

    /**
     * The entry object.
     *
     * @var mixed
     */
    protected $entry;

    /**
     * Create a new GetFormatterValue instance.
     *
     * @param Resource           $resource
     * @param FormatterInterface $formatter
     * @param                    $entry
     */
    function __construct(Resource $resource, FormatterInterface $formatter, $entry)
    {
        $this->entry     = $entry;
        $this->resource  = $resource;
        $this->formatter = $formatter;
    }

    /**
     * Get the formatter object.
     *
     * @return FormatterInterface
     */
    public function getFormatter()
    {
        return $this->formatter;
    }

    /**
     * Get the resource object.
     *
     * @return Resource
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * Get the entry object.
     *
     * @return mixed
     */
    public function getEntry()
    {
        return $this->entry;
    }
}
