<?php namespace Anomaly\ApiModule\Resource\Component\Field\Command;

use Anomaly\ApiModule\Resource\ResourceBuilder;

/**
 * Class BuildFields
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Field\Command
 */
class BuildFields
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildFields instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Get the resource builder.
     *
     * @return ResourceBuilder
     */
    public function getBuilder()
    {
        return $this->builder;
    }
}
