<?php namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\ResourceAuthorizer;
use Anomaly\ApiModule\Resource\ResourceBuilder;


/**
 * Class AuthorizeResource
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class AuthorizeResource
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildResourceFormattersCommand instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param ResourceAuthorizer $authorizer
     */
    public function handle(ResourceAuthorizer $authorizer)
    {
        $authorizer->authorize($this->builder);
    }
}
