<?php namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\Component\Result\Result;
use Anomaly\ApiModule\Resource\ResourceBuilder;
use Anomaly\ApiModule\Resource\ResourcePagination;
use Anomaly\Streams\Platform\Support\Evaluator;

/**
 * Class AddEntriesData
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class AddEntriesData
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildResourceFormattersCommand instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * * @param Evaluator $evaluator
     * @param ResourcePagination $pagination
     */
    public function handle(Evaluator $evaluator, ResourcePagination $pagination)
    {
        $entries = array_map(
            function (Result $result) {
                return (object)$result->toArray();
            },
            $this->builder->getResourceResults()->all()
        );

        if ($this->builder->getId()) {
            $this->builder->addResourceData('data', array_shift($entries));
        } else {

            $this->builder->addResourceData('data', $entries);

            if (!$this->builder->getResourceOption('map')) {
                $this->builder->addResourceData('pagination', $pagination->make($this->builder));
            }
        }
    }
}
