<?php namespace Anomaly\ApiModule\Client\Form;

use Anomaly\ApiModule\Client\ClientModel;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\UserModel;

/**
 * Class ClientFormBuilder
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ClientFormBuilder extends FormBuilder
{

    /**
     * The form model.
     *
     * @var ClientModel
     */
    protected $model = ClientModel::class;

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [
        'user'   => [
            'fields' => [
                'user_id',
            ],
        ],
        'client' => [
            'fields' => [
                'name',
                'redirect',
            ],
        ],
    ];


    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'permission' => 'anomaly.module.api::clients.write',
        'redirect' => '/admin/api'
    ];
}
