<?php namespace Anomaly\ApiModule\Resource\Component\Formatter\Command;

use Anomaly\ApiModule\Resource\ResourceBuilder;

/**
 * Class BuildFormatters
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Formatter\Command
 */
class BuildFormatters
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildFormatters instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Get the resource builder.
     *
     * @return ResourceBuilder
     */
    public function getBuilder()
    {
        return $this->builder;
    }
}
