<?php namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\Resource;
use Anomaly\ApiModule\Resource\ResourcePagination;


/**
 * Class LoadResourcePagination
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class LoadResourcePagination
{

    /**
     * The resource object.
     *
     * @var Resource
     */
    protected $resource;

    /**
     * Create a new LoadResourcePagination instance.
     *
     * @param Resource $resource
     */
    public function __construct(Resource $resource)
    {
        $this->resource = $resource;
    }

    /**
     * Handle the command.
     *
     * @param ResourcePagination $pagination
     */
    public function handle(ResourcePagination $pagination)
    {
        $data = $this->resource->getData();

        if ($this->resource->getOption('paginate') === false) {
            return;
        }

        $pagination = $pagination->make($this->resource);

        $data->put('pagination', $pagination);
    }
}
