<?php namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\Component\Result\Command\BuildResults;
use Anomaly\ApiModule\Resource\ResourceBuilder;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class BuildResource
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class BuildResource
{

    use DispatchesJobs;

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildResourceFormattersCommand instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        /**
         * Resolve and set the resource model and stream.
         */
        $this->dispatch(new HydrateFromRequest($this->builder));
        $this->dispatch(new SetResourceModel($this->builder));
        $this->dispatch(new SetResourceStream($this->builder));
        $this->dispatch(new SetDefaultParameters($this->builder));
        $this->dispatch(new SetRepository($this->builder));

        $this->dispatch(new SetResourceOptions($this->builder));
        $this->dispatch(new SetDefaultOptions($this->builder));

        /**
         * Before we go any further, authorize the request.
         */
        $this->dispatch(new AuthorizeResource($this->builder));

        /**
         * Get resource entries.
         */
        $this->dispatch(new GetResourceEntries($this->builder));

        /**
         * Lastly resource results.
         */
        $this->dispatch(new BuildResults($this->builder));
    }
}
