<?php namespace Anomaly\ApiModule\Http\Controller\Admin;

use Anomaly\ApiModule\Client\Form\ClientFormBuilder;
use Anomaly\ApiModule\Client\Table\ClientTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

/**
 * Class ClientsController
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ClientsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ClientTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ClientTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ClientFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ClientFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ClientFormBuilder $form
     * @param                   $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ClientFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
