<?php namespace Anomaly\Streams\Platform\Ui\Entity\Component\Button;

use Anomaly\Streams\Platform\Ui\Entity\EntityBuilder;

/**
 * Class ButtonDefaults
 *
 * @link          http://anomaly.is/streams-platentity
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Ui\Entity\Component\Button
 */
class ButtonDefaults
{

    /**
     * Default the entity buttons when none are defined.
     *
     * @param EntityBuilder $builder
     */
    public function defaults(EntityBuilder $builder)
    {
        if ($builder->getButtons() === []) {
            $builder->setButtons(['cancel']);
        }
    }
}
