<?php namespace Anomaly\ApiModule\Resource\Event;

use Anomaly\ApiModule\Resource\ResourceBuilder;
use Illuminate\Database\Eloquent\Builder;

/**
 * Class ResourceIsQuerying
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Event
 */
class ResourceIsQuerying
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * The resource query.
     *
     * @var Builder
     */
    protected $query;

    /**
     * Create a new ResourceIsQuerying instance.
     *
     * @param ResourceBuilder $builder
     * @param Builder         $query
     */
    public function __construct(ResourceBuilder $builder, Builder $query)
    {
        $this->builder = $builder;
        $this->query   = $query;
    }

    /**
     * Get the query.
     *
     * @return Builder
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Get the resource.
     *
     * @return ResourceBuilder
     */
    public function getBuilder()
    {
        return $this->builder;
    }
}
