<?php

namespace Anomaly\ApiModule\Resource\Component\Result;

use Anomaly\ApiModule\Resource\Component\Result\Contract\ResultInterface;
use Anomaly\Streams\Platform\Support\Hydrator;

/**
 * Class ResultFactory
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ResultFactory
{

    /**
     * The hydrator utility.
     *
     * @var Hydrator
     */
    protected $hydrator;

    /**
     * Create a new ResultFactory instance.
     *
     * @param Hydrator  $hydrator
     */
    public function __construct(Hydrator $hydrator)
    {
        $this->hydrator = $hydrator;
    }

    /**
     * Make a result.
     *
     * @param  array $parameters
     * @return ResultInterface
     */
    public function make(array $parameters)
    {
        $result = app(Result::class, $parameters);

        $this->hydrator->hydrate($result, $parameters);

        return $result;
    }
}
