<?php namespace Anomaly\ApiModule\Resource\Component\Result;

use Anomaly\ApiModule\Resource\Component\Formatter\Formatter;
use Anomaly\ApiModule\Resource\Component\Result\Contract\ResultInterface;
use Anomaly\ApiModule\Resource\Resource;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\Traits\Hookable;
use Illuminate\Support\Collection;

/**
 * Class Result
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Result
 */
class Result implements ResultInterface
{

    /**
     * The result entry.
     *
     * @var mixed|Hookable
     */
    protected $entry = null;

    /**
     * The result resource.
     *
     * @var null|Resource|EloquentModel
     */
    protected $resource = null;

    /**
     * The result formatters.
     *
     * @var Collection
     */
    protected $formatters;

    /**
     * Set the result formatters.
     *
     * @param Collection $formatters
     * @return $this
     */
    public function setFormatters(Collection $formatters)
    {
        $this->formatters = $formatters;

        return $this;
    }

    /**
     * Get the result formatters.
     *
     * @return mixed
     */
    public function getFormatters()
    {
        return $this->formatters;
    }

    /**
     * Get the resource.
     *
     * @return Resource|null
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * Set the resource.
     *
     * @param Resource $resource
     * @return $this
     */
    public function setResource(Resource $resource)
    {
        $this->resource = $resource;

        return $this;
    }

    /**
     * Set the result entry.
     *
     * @param $entry
     * @return $this
     */
    public function setEntry($entry)
    {
        $this->entry = $entry;

        return $this;
    }

    /**
     * Get the result entry.
     *
     * @return mixed|EloquentModel
     */
    public function getEntry()
    {
        return $this->entry;
    }

    /**
     * Return an array.
     */
    public function toArray()
    {
        $entry = $this->entry->hasHook('to_array_for_api')
            ? $this->entry->call('to_array_for_api')
            : $this->entry->toArray();

        /* @var Formatter $formatter */
        foreach ($this->getFormatters() as $formatter) {
            $entry[$formatter->getField()] = $formatter->getOutput();
        }

        return $entry;
    }
}
