<?php namespace Anomaly\ApiModule\Resource\Component\Formatter;

use Anomaly\ApiModule\Resource\Component\Formatter\Contract\FormatterInterface;
use Anomaly\Streams\Platform\Support\Hydrator;

/**
 * Class FormatterFactory
 *
 * @link    http://anomaly.is/streams-platform
 * @author  AnomalyLabs, Inc. <hello@anomaly.is>
 * @author  Ryan Thompson <ryan@anomaly.is>
 * @package Anomaly\ApiModule\Resource\Component\Formatter
 */
class FormatterFactory
{

    /**
     * The default formatter class.
     *
     * @var string
     */
    protected $formatter = Formatter::class;

    /**
     * The hydrator utility.
     *
     * @var Hydrator
     */
    protected $hydrator;

    /**
     * Create a new FormatterFactory instance.
     *
     * @param Hydrator $hydrator
     */
    public function __construct(Hydrator $hydrator)
    {
        $this->hydrator = $hydrator;
    }

    /**
     * Make a formatter.
     *
     * @param  array $parameters
     * @return FormatterInterface
     */
    public function make(array $parameters)
    {
        $formatter = app()->make(array_get($parameters, 'formatter', $this->formatter), $parameters);

        $this->hydrator->hydrate($formatter, $parameters);

        return $formatter;
    }
}
