<?php namespace Anomaly\ApiModule\Resource\Component\Formatter\Command\Handler;

use Anomaly\ApiModule\Resource\Component\Formatter\Command\GetFormatterValue;
use Anomaly\ApiModule\Resource\Component\Formatter\FormatterValue;

/**
 * Class GetFormatterValueHandler
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Component\Formatter\Command
 */
class GetFormatterValueHandler
{

    /**
     * The value utility.
     *
     * @var \Anomaly\ApiModule\Resource\Component\Formatter\FormatterValue
     */
    protected $value;

    /**
     * Create a new GetFormatterValueHandler instance.
     *
     * @param FormatterValue $value
     */
    public function __construct(FormatterValue $value)
    {
        $this->value = $value;
    }

    /**
     * Handle the command.
     *
     * @param GetFormatterValue $command
     * @return mixed
     */
    public function handle(GetFormatterValue $command)
    {
        $entry     = $command->getEntry();
        $resource  = $command->getResource();
        $formatter = $command->getFormatter();

        return $this->value->make($resource, $formatter, $entry);
    }
}
