<?php

namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\ResourceBuilder;

/**
 * Class SetResourceResponse
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class SetResourceResponse
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new SetResourceResponse instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        switch (strtolower($this->builder->getResourceOption('format', 'json'))) {

            case 'json':
                $response = dispatch_now(new MakeJsonResponse($this->builder));
                break;

            case 'xml':
                $response = dispatch_now(new MakeXmlResponse($this->builder));
                break;

            case 'html':
                $response = dispatch_now(new MakeViewResponse($this->builder));
                break;

            default:
                $response = dispatch_now(new MakeViewResponse($this->builder));
        }

        $this->builder->setResourceResponse($response);
    }
}
