<?php

namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\Repository\EloquentResourceRepository;
use Anomaly\ApiModule\Resource\Repository\EntryResourceRepository;
use Anomaly\ApiModule\Resource\ResourceBuilder;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Model\EloquentModel;

/**
 * Class SetRepository
 *
 * @link   http://pyrocms.com/
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class SetRepository
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new SetRepository instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {

        /**
         * Set the default options handler based
         * on the builder class. Defaulting to
         * no handler.
         */
        if (!$this->builder->getRepository()) {

            $model = $this->builder->getResourceModel();

            if (!$this->builder->getRepository() && $model instanceof EntryModel) {
                $this->builder->setRepository(app(EntryResourceRepository::class, compact('model')));
            } elseif (!$this->builder->getRepository() && $model instanceof EloquentModel) {
                $this->builder->setRepository(app(EloquentResourceRepository::class, compact('model')));
            }
        }
    }
}
