<?php

namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\Component\Action\Command\ExecuteAction;
use Anomaly\ApiModule\Resource\Multiple\MultipleResourceBuilder;
use Anomaly\ApiModule\Resource\ResourceBuilder;
use Illuminate\Http\Request;
use Illuminate\Routing\ResponseFactory;

/**
 * Class PostResource
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class PostResource
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new PostResource instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param Request         $request
     * @param ResponseFactory $response
     * @throws \Exception
     */
    public function handle(Request $request, ResponseFactory $response)
    {
        if ($this->builder instanceof MultipleResourceBuilder) {
            return;
        }

        dispatch_now(new ExecuteAction($this->builder));

        if (!$this->builder->getResourceResponse()) {
            $this->builder->setResourceResponse($response->redirectTo($request->fullUrl()));
        }
    }
}
