<?php

namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\ResourceBuilder;

/**
 * Class MakeResource
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class MakeResource
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new MakeResource instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        $resource = $this->builder->getResource();

        if ($handler = $this->builder->getResourceOption('data')) {

            // Self handling implies @handle
            if (is_string($handler) && !str_contains($handler, '@')) {
                $handler .= '@handle';
            }

            app()->call($handler, compact('resource'));
        }

        // Make sure entries are in there.
        if (!$this->builder->getResourceDataItem('entries')) {
            dispatch_now(new AddEntriesData($this->builder));
        }
    }
}
