<?php

namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\ResourceBuilder;
use Anomaly\Streams\Platform\Ui\Breadcrumb\BreadcrumbCollection;
use Anomaly\Streams\Platform\View\ViewTemplate;

/**
 * Class LoadResource
 *
 * @link   http://pyrocms.com/
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class LoadResource
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new LoadResource instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param ViewTemplate         $template
     * @param BreadcrumbCollection $breadcrumbs
     */
    public function handle()
    {
        $resource = $this->builder->getResource();

        if ($handler = $this->builder->getResourceOption('data')) {

            // Self handling implies @handle
            if (is_string($handler) && !str_contains($handler, '@')) {
                $handler .= '@handle';
            }

            app()->call($handler, compact('resource'));
        }
    }
}
