<?php

namespace Anomaly\ApiModule\Resource\Command;

use Anomaly\ApiModule\Resource\Component\Result\Command\BuildResults;
use Anomaly\ApiModule\Resource\ResourceBuilder;

/**
 * Class BuildResource
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\ApiModule\Resource\Command
 */
class BuildResource
{

    /**
     * The resource builder.
     *
     * @var ResourceBuilder
     */
    protected $builder;

    /**
     * Create a new BuildResourceFormattersCommand instance.
     *
     * @param ResourceBuilder $builder
     */
    public function __construct(ResourceBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        /**
         * Resolve and set the resource model and stream.
         */
        dispatch_now(new HydrateFromRequest($this->builder));
        dispatch_now(new SetResourceModel($this->builder));
        dispatch_now(new SetResourceStream($this->builder));
        dispatch_now(new SetDefaultParameters($this->builder));
        dispatch_now(new SetRepository($this->builder));

        dispatch_now(new SetResourceOptions($this->builder));
        dispatch_now(new SetDefaultOptions($this->builder));

        /**
         * Before we go any further, authorize the request.
         */
        dispatch_now(new AuthorizeResource($this->builder));

        /**
         * Get resource entries.
         */
        dispatch_now(new GetResourceEntries($this->builder));

        /**
         * Lastly resource results.
         */
        dispatch_now(new BuildResults($this->builder));
    }
}
