<?php

namespace Anomaly\Streams\Platform\Ui\Entity\Component\Action;

use Anomaly\Streams\Platform\Ui\Entity\Component\Action\Contract\ActionHandlerInterface;
use Anomaly\Streams\Platform\Ui\Entity\Component\Action\Contract\ActionInterface;
use Anomaly\Streams\Platform\Ui\Entity\EntityBuilder;

/**
 * Class ActionResponder
 *
 * @link   http://pyrocms.com/
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ActionResponder
{

    /**
     * Set the entity response using the active action
     * entity response handler.
     *
     * @param \Anomaly\Streams\Platform\Ui\Entity\EntityBuilder $builder
     * @param \Anomaly\Streams\Platform\Ui\Entity\Component\Action\Contract\ActionInterface $action
     */
    public function setEntityResponse(EntityBuilder $builder, ActionInterface $action)
    {
        $handler = $action->getHandler();

        // Self handling implies @handle
        if (is_string($handler) && !str_contains($handler, '@') && class_implements($handler, SelfHandling::class)) {
            $handler .= '@handle';
        }

        /**
         * If the handler is a closure or callable
         * string then call it using the service container.
         */
        if (is_string($handler) || $handler instanceof \Closure) {
            app()->call($handler, compact('builder'));
        }

        /**
         * If the handle is an instance of ActionHandlerInterface
         * simply call the handle method on it.
         */
        if ($handler instanceof ActionHandlerInterface) {
            $handler->handle($builder);
        }
    }
}
