<?php

namespace Anomaly\Streams\Platform\Ui\Entity\Command;

use Anomaly\Streams\Platform\Entry\EntryEntityRepository;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Model\EloquentEntityRepository;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\Ui\Entity\EntityBuilder;

/**
 * Class SetRepository
 *
 * @link    http://anomaly.is/streams-platentity
 * @author  AnomalyLabs, Inc. <hello@anomaly.is>
 * @author  Ryan Thompson <ryan@anomaly.is>
 */
class SetRepository
{

    /**
     * The entity builder.
     *
     * @var EntityBuilder
     */
    protected $builder;

    /**
     * Create a new SetRepository instance.
     *
     * @param EntityBuilder $builder
     */
    public function __construct(EntityBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        /**
         * Set the default options handler based
         * on the builder class. Defaulting to
         * no handler.
         */
        if (!$this->builder->getRepository()) {

            $model  = $this->builder->getEntityModel();
            $entity = $this->builder->getEntity();

            $repository = str_replace('EntityBuilder', 'EntityRepository', get_class($this->builder));

            if (!$this->builder->getRepository() && class_exists($repository)) {
                $this->builder->setRepository(
                    app($repository, compact('entity', 'model'))
                );
            } elseif (!$this->builder->getRepository() && $model instanceof EntryModel) {
                $this->builder->setRepository(
                    app(EntryEntityRepository::class, compact('entity', 'model'))
                );
            } elseif (!$this->builder->getRepository() && $model instanceof EloquentModel) {
                $this->builder->setRepository(
                    app(EloquentEntityRepository::class, compact('entity', 'model'))
                );
            }
        }
    }
}
