<?php

namespace Anomaly\Streams\Platform\Ui\Entity\Command;

use Anomaly\Streams\Platform\Ui\Entity\EntityBuilder;

/**
 * Class PostEntity
 *
 * @link          http://anomaly.is/streams-platentity
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Ui\Entity\Command
 */
class PostEntity
{

    /**
     * The entity builder.
     *
     * @var EntityBuilder
     */
    protected $builder;

    /**
     * Create a new PostEntity instance.
     *
     * @param EntityBuilder $builder
     */
    public function __construct(EntityBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        $this->builder->fire('posting', ['builder' => $this->builder]);
        $this->builder->fireFieldEvents('entity_posting');

        dispatch_now(new LoadEntityValues($this->builder));
        dispatch_now(new ValidateEntity($this->builder));
        dispatch_now(new RemoveSkippedFields($this->builder));
        dispatch_now(new HandleEntity($this->builder));
        dispatch_now(new SetSuccessMessage($this->builder));
        dispatch_now(new SetActionResponse($this->builder));

        if ($this->builder->isAjax()) {
            dispatch_now(new SetJsonResponse($this->builder));
        }

        $this->builder->fire('posted', ['builder' => $this->builder]);
        $this->builder->fireFieldEvents('entity_posted');
    }
}
