<?php

namespace Anomaly\Streams\Platform\Ui\Entity\Command;

use Anomaly\Streams\Platform\Ui\Breadcrumb\BreadcrumbCollection;
use Anomaly\Streams\Platform\Ui\Entity\EntityBuilder;
use Anomaly\Streams\Platform\View\ViewTemplate;

/**
 * Class LoadEntity
 *
 * @link          http://anomaly.is/streams-platentity
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Ui\Entity\Command
 */
class LoadEntity
{

    /**
     * The entity builder.
     *
     * @var EntityBuilder
     */
    protected $builder;

    /**
     * Create a new HandleEntity instance.
     *
     * @param EntityBuilder $builder
     */
    public function __construct(EntityBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param ViewTemplate         $template
     * @param BreadcrumbCollection $breadcrumbs
     */
    public function handle(ViewTemplate $template, BreadcrumbCollection $breadcrumbs)
    {
        $entity = $this->builder->getEntity();

        if ($handler = $entity->getOption('data')) {
            app()->call($handler, compact('entity'));
        }

        if ($layout = $entity->getOption('layout_view')) {
            $template->include('layout', $layout);
        }

        if ($title = $entity->getOption('title')) {
            $template->include('title', $title);
        }

        $entity->addData('entity', $entity);

        if ($breadcrumb = $entity->getOption('breadcrumb', 'streams::entity.mode.' . $entity->getMode())) {
            $breadcrumbs->put($breadcrumb, '#');
        }
    }
}
