<?php

namespace Anomaly\Streams\Platform\Ui\Entity\Command;

use Anomaly\Streams\Platform\Ui\Entity\Component\Action\Command\BuildActions;
use Anomaly\Streams\Platform\Ui\Entity\Component\Action\Command\SetActiveAction;
use Anomaly\Streams\Platform\Ui\Entity\Component\Button\Command\BuildButtons;
use Anomaly\Streams\Platform\Ui\Entity\Component\Field\Command\BuildFields;
use Anomaly\Streams\Platform\Ui\Entity\Component\Section\Command\BuildSections;
use Anomaly\Streams\Platform\Ui\Entity\EntityBuilder;

/**
 * Class BuildEntity
 *
 * @link          http://anomaly.is/streams-platentity
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Ui\Entity\Command
 */
class BuildEntity
{

    /**
     * The entity builder.
     *
     * @var EntityBuilder
     */
    protected $builder;

    /**
     * Create a new BuildEntityColumnsCommand instance.
     *
     * @param EntityBuilder $builder
     */
    public function __construct(EntityBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        /**
         * Setup some objects and options using
         * provided input or sensible defaults.
         */
        dispatch_now(new SetEntityModel($this->builder));
        dispatch_now(new SetEntityStream($this->builder));
        dispatch_now(new SetDefaultParameters($this->builder));
        dispatch_now(new SetRepository($this->builder));

        dispatch_now(new SetEntityOptions($this->builder));
        dispatch_now(new SetEntityEntry($this->builder)); // Do this last.

        /**
         * Before we go any further, authorize the request.
         */
        dispatch_now(new AuthorizeEntity($this->builder));

        /*
         * Build entity fields.
         */
        dispatch_now(new BuildFields($this->builder));

        /**
         * Build entity sections.
         */
        dispatch_now(new BuildSections($this->builder));

        /**
         * Build entity actions and flag active.
         */
        dispatch_now(new BuildActions($this->builder));
        dispatch_now(new SetActiveAction($this->builder));

        /**
         * Build entity buttons.
         */
        dispatch_now(new BuildButtons($this->builder));
    }
}
