<?php namespace Anomaly\ApiModule\Client\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Model;
use Laravel\Passport\Client;

/**
 * Class ClientTableBuilder
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ClientTableBuilder extends TableBuilder
{

    /**
     * The table model.
     *
     * @var Model
     */
    protected $model = Client::class;

    /**
     * The table filters.
     *
     * @var array
     */
    protected $filters = [
        'search' => [
            'columns' => [
                'name',
                'redirect',
            ],
        ],
    ];

    /**
     * The table columns.
     *
     * @var array
     */
    protected $columns = [
        'entry.id'   => [
            'sort_column' => 'id',
            'heading'     => 'anomaly.module.api::field.client.name',
        ],
        [
            'sort_column' => 'user_id',
            'value'       => '{{ user(entry.user_id).username }}',
            'heading'     => 'anomaly.module.api::field.user.name',
        ],
        'entry.name' => [
            'sort_column' => 'name',
            'heading'     => 'anomaly.module.api::field.name.name',
        ],
    ];

    /**
     * The table actions.
     *
     * @var array
     */
    protected $actions = [
        'delete',
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'permission' => 'anomaly.module.api::clients.read',
    ];
}
