<?php namespace Anomaly\ApiModule\Client\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\UserModel;
use Laravel\Passport\Client;

/**
 * Class ClientFormBuilder
 *
 * @link   http://pyrocms.com/
 * @author PyroCMS, Inc. <support@pyrocms.com>
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ClientFormBuilder extends FormBuilder
{

    /**
     * The form model.
     *
     * @var Client
     */
    protected $model = Client::class;

    /**
     * The form fields.
     *
     * @var array
     */
    protected $fields = [
        'user_id'  => [
            'required'     => true,
            'label'        => 'anomaly.module.api::field.user.name',
            'instructions' => 'anomaly.module.api::field.user.instructions',
            'type'         => 'anomaly.field_type.relationship',
            'config'       => [
                'mode'    => 'lookup',
                'related' => UserModel::class,
            ],
        ],
        'name'     => [
            'required'     => true,
            'label'        => 'anomaly.module.api::field.name.name',
            'instructions' => 'anomaly.module.api::field.name.instructions',
            'type'         => 'anomaly.field_type.text',
        ],
        'redirect' => [
            'required'     => true,
            'label'        => 'anomaly.module.api::field.redirect.name',
            'instructions' => 'anomaly.module.api::field.redirect.instructions',
            'type'         => 'anomaly.field_type.url',
        ],
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [
        'user'   => [
            'fields' => [
                'user_id',
            ],
        ],
        'client' => [
            'fields' => [
                'name',
                'redirect',
            ],
        ],
    ];


    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'permission' => 'anomaly.module.api::clients.write',
    ];
}
