<?php

namespace Anomaly\ApiModule;

use Anomaly\ApiModule\Command\DeleteKeys;
use Anomaly\ApiModule\Command\GenerateKeys;
use Anomaly\Streams\Platform\Addon\Module\Module;
use Anomaly\Streams\Platform\Console\Kernel;

/**
 * Class ApiModule
 *
 * @link   http://pyrocms.com/
 * @author Ryan Thompson <ryan@pyrocms.com>
 */
class ApiModule extends Module
{

    /**
     * The navigation icon.
     *
     * @var string
     */
    protected $icon = 'keys';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'clients' => [
            'buttons' => [
                'new_client' => [
                    'permission' => 'anomaly.module.api::clients.write',
                ],
            ],
        ],
    ];

    /**
     * Fire after installing.
     *
     * @param Kernel $console
     */
    public function onInstalled(Kernel $console)
    {
        $console->call(
            'migrate',
            [
                '--path'  => 'vendor/laravel/passport/database/migrations/',
                '--force' => true,
            ]
        );

        dispatch_now(new GenerateKeys());
    }

    /**
     * Fire after installing.
     *
     * @param Kernel $console
     */
    public function onUninstalled(Kernel $console)
    {
        $console->call(
            'migrate:reset',
            [
                '--path'  => 'vendor/laravel/passport/database/migrations/',
                '--force' => true,
            ]
        );

        dispatch_now(new DeleteKeys());
    }
}
