---
title: Issuing Tokens 
---

### Issuing Tokens

This section will provide a brief overview of how to create access tokens for your API.

[Laravel Passport](https://laravel.com/docs/5.3/passport) handles all of the client and token management for the API module. Please refer to Laravel docs for more detailed information on how to manage clients and issue tokens.

#### Issuing Access Tokens

This section will show you how to quickly issue access tokens for your API.

##### Creating a Client

To begin we first need to create our API client:

    php artisan passport:client

Provide the information requested about your client and take note of the client ID and secret provided. For this example we will assume your **callback URL** is `http://workbench.local:8888/callback`.

> The user specified for the client will provide the permissions level for tokens associated with this client.{.tip}

##### Create the Callback

Next we need to create the redirect URL we specified in the above step. In this case we're assuming it's `http://workbench.local:8888/callback` so let's open our `routes/web.php` file and copy the following code into it:

    Route::get(
        '/callback',
        function (\Illuminate\Http\Request $request) {
            $http = new GuzzleHttp\Client;

            $response = $http->post(
                'http://workbench.local:8888/oauth/token',
                [
                    'form_params' => [
                        'grant_type'    => 'authorization_code',
                        'client_id'     => CLIENT_ID,
                        'client_secret' => CLIENT_SECRET,
                        'redirect_uri'  => 'http://workbench.local:8888/callback',
                        'code'          => $request->code,
                    ],
                ]
            );

            return json_decode((string)$response->getBody(), true);
        }
    );

##### Requesting a Token

To get request a token open your browser and login to your application.

Next, navigate to `/oauth/request?client=CLIENT_ID` and accept the authorization request.

You will be redirected to the callback URL we just created and you should see a token and refresh token displayed on your screen. Store the tokens in your consuming application and start making API requests!

#### Issuing Password Grant Tokens

This section will show you how to quickly issue password grant access tokens for your API.

##### Creating a Client

To begin we first need to create our API client with the `--password` option:

    php artisan passport:client --password

##### Requesting a Token

To request a password grant token you must make a `POST` request to `/oauth/tokens`. With `Guzzle` that might look something like this:

    $http = new GuzzleHttp\Client;

    $response = $http->post(
        'http://yoursite.com/oauth/token',
        [
            'form_params' => [
                'grant_type'    => 'password',
                'client_id'     => CLIENT_ID,
                'client_secret' => CLIENT_SECRET,
                'username'      => USER_EMAIL,
                'password'      => USER_PASSWORD,
            ],
        ]
    );

    return json_decode((string)$response->getBody(), true);

The response will contain your access and refresh tokens. Store the tokens in your consuming application and start making API requests!

> The user credentials provided will determine the permissions level for the token returned.{.tip}

#### Issuing Personal Access Tokens

This section will show you how to quickly issue personal access tokens for your API.

##### Creating a Client

To begin we first need to create our API client with the `--personal` option:

    php artisan passport:client --personal

##### Creating a Token

To create a personal access token you can open up `Tinker`:

    php artisan tinker

And run the following after replacing the variables with your desired ID and name:

    app(\Anomaly\ApiModule\User\UserModel::class)->find($id)->createToken($tokenName)->accessToken;

> The user specified will provide the permissions level for the access token.{.tip}
