---
title: Scopes 
---

### Scopes

Scopes help you lock features of your API. This section will go over how to define and check scopes for your API.

#### Defining Scopes

The API module defines scopes for Laravel's Passport package using the `api.php` configuration file.

Simply define your application's available scopes and reference them just as you normally would with Passport.

Please refer to [Laravel Passport documentation](https://laravel.com/docs/5.3/passport#token-scopes) for more information on scopes.

#### Checking Scopes

The API module uses the two included Passport middleware to verify that an incoming request is authenticated with a token that has been granted a given scope:

    'scopes' => \Laravel\Passport\Http\Middleware\CheckScopes::class,
    'scope' => \Laravel\Passport\Http\Middleware\CheckForAnyScope::class,

##### Check For All Scopes

The scopes middleware may be assigned to a route to verify that the incoming request's access token has all of the listed scopes:

    protected $api = [
        'api/example-module/test' => [
            'uses' => 'Anomaly\ExampleModule\Http\Controller\Api\TestController@doSomething',
            'middleware' => 'scopes:check-status,place-orders'
        ]
    ];

And with the router:

    Route::get('/orders', function () {
        // Access token has both "check-status" and "place-orders" scopes...
    })->middleware('scopes:check-status,place-orders');

##### Check For Any Scopes

The scope middleware may be assigned to a route to verify that the incoming request's access token has at least one of the listed scopes:

    protected $api = [
        'api/example-module/test' => [
            'uses' => 'Anomaly\ExampleModule\Http\Controller\Api\TestController@doSomething',
            'middleware' => 'scope:check-status,place-orders'
        ]
    ];

And with the router:

    Route::get('/orders', function () {
        // Access token has either "check-status" or "place-orders" scope...
    })->middleware('scope:check-status,place-orders');

##### Checking Scopes On A Token Instance

Once an access token authenticated request has entered your application, you may still check if the token has a given scope using the tokenCan method on the authenticated User instance:

    use Illuminate\Http\Request;

    Route::get('/orders', function (Request $request) {
        if ($request->user()->tokenCan('place-orders')) {
            //
        }
    });
